/*
 * Decompiled with CFR 0.152.
 */
package dev.redstones.mediaplayerinfo;

import dev.redstones.mediaplayerinfo.IMediaSession;
import dev.redstones.mediaplayerinfo.impl.DummyMediaPlayerInfo;
import dev.redstones.mediaplayerinfo.impl.win.WindowsMediaPlayerInfo;
import java.util.List;

public interface MediaPlayerInfo {
    public static final MediaPlayerInfo INSTANCE = SystemMediaPlayerInfo.getInstance();

    public List<IMediaSession> getMediaSessions();

    public static class SystemMediaPlayerInfo {
        private static final MediaPlayerInfo instance = SystemMediaPlayerInfo.createInstance();

        private static MediaPlayerInfo createInstance() {
            if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                return new DummyMediaPlayerInfo();
            }
            try {
                return new WindowsMediaPlayerInfo();
            }
            catch (Exception e) {
                System.err.println("Failed to initialize WindowsMediaPlayerInfo, falling back to dummy: " + e.getMessage());
                return new DummyMediaPlayerInfo();
            }
        }

        public static MediaPlayerInfo getInstance() {
            return instance;
        }
    }
}

